---
title: Application-aware policies · Cloudflare Magic WAN docs
description: In addition to traffic policies based on network-layer attributes
  like IP and port ranges, Magic WAN Connector supports the ability to classify
  traffic based on well-known applications. Application-aware policies provide
  easier management and more granularity over traffic flows.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/application-based-policies/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/application-based-policies/index.md
---

In addition to traffic policies based on network-layer attributes like IP and port ranges, Magic WAN Connector supports the ability to classify traffic based on well-known applications. Application-aware policies provide easier management and more granularity over traffic flows.

Cloudflare's implementation of application awareness leverages the intelligence of our global network, using the same categorization/classification already shared across security tools like our [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/), so IT and security teams can expect consistent behavior across routing and inspection decisions.

For more information, refer to [Applications and app types](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/).

Magic WAN Connector's ability to classify traffic allows you to define which applications should bypass Cloudflare's security filtering, and go directly to the Internet. You can also give some applications a higher priority, and Connector will process them first. This is useful when your network is at capacity, for example.

Refer to the following pages for more information.

* [Breakout traffic](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/application-based-policies/breakout-traffic/)
* [Prioritized traffic](https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/application-based-policies/prioritized-traffic/)
