---
title: Glossary | Cloudflare Docs
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/glossary/
  md: https://developers.cloudflare.com/glossary/index.md
---

Beta

| Term | Definition | Product |
| - | - | - |
| account | Accounts group one or more members together with specific roles or permissions. Accounts can be associated with any number of domains. | Fundamentals |
| ACK (Acknowledge) | The final step in the TCP three-way handshake, confirming the establishment of a connection. | Spectrum |
| active zone | A DNS zone that is active on Cloudflare requires changing its nameservers to Cloudflare's for management. | DNS |
| address map | A data structure enabling customers with BYOIP prefixes or account-level static IPs to specify which IP addresses should be mapped to DNS records when they are proxied through Cloudflare. | BYOIP |
| AI crawler | A bot which scrapes content from websites in support of an AI model, including by scraping content for indexing, retrieval augmented generation, or training. | AI Crawl Control |
| AI models | [An AI model](https://developers.cloudflare.com/workers-ai/models) is a trained system that processes input data to generate predictions, decisions, or outputs based on patterns it has learned. | Workers AI |
| alarm | A Durable Object alarm is a mechanism that allows you to schedule the Durable Object to be woken up at a time in the future. | Durable Objects |
| allowlist | An allowlist is a list of items (usually websites, IP addresses, email addresses, etc.) that are permitted to access a system. | WAF |
| anycast | Anycast is a network addressing and routing method in which incoming requests can be routed to a variety of different locations. Anycast typically routes incoming traffic to the nearest data center with the capacity to process the request efficiently. | Magic WAN |
| apex domain | Apex domain is used to refer to a domain that does not contain a subdomain part, such as `example.com` (without `www.`). It is also known as "root domain" or "naked domain". | DNS |
| API call | Also known as an API request. An API call is a message sent to a server asking an API to provide a service or information. | API Shield |
| API endpoint | The API endpoint is the location where API calls or requests are fulfilled. API Shield defines endpoints as a host, method, and path tuple. | API Shield |
| API key | An API key is unique to each Cloudflare user and used to confirm identity when using the [Cloudflare API](https://developers.cloudflare.com/api/). | Fundamentals |
| API schema | The API schema defines which API requests are valid based on several request properties like target endpoint, path or query variable format, and HTTP method. | API Shield |
| API token | API tokens authorize access to specific Cloudflare dashboard pages, accounts, and zones. API tokens are associated to the user that created them. | Fundamentals |
| API Tokens | [API Tokens](https://developers.cloudflare.com/workers-ai/get-started/rest-api/) are authentication credentials used to securely access and manage Workers AI resources via the REST API. | Workers AI |
| App Launcher | The App Launcher portal provides end users with a single dashboard to open applications secured by Cloudflare One. | Cloudflare One |
| application | The resource protected by Cloudflare One, which can be a subdomain, a path, or a SaaS application. | Cloudflare One |
| application token | A piece of data that grants a user access to a specific Access application for a period of time. Can be stored in a browser cookie or passed to the application in place of a normal password. | Cloudflare One |
| attack score | A number from 1 (likely malicious) to 99 (likely clean) classifying how likely an incoming request is malicious or not. Allows you to detect new attack techniques before they are publicly known. | WAF |
| attribute | Traffic that flows through Area 1 can receive one or more attributes, which indicate that a specific condition has been met. | Area 1 |
| Authenticated Origin Pulls | Authenticated Origin Pulls allow origin web servers to validate that a web request came from Cloudflare using TLS client certificate authentication. | SSL/TLS |
| autonomous system numbers (ASNs) | A large network or group of networks that has a unified routing policy. Every computer or device that connects to the Internet is connected to an autonomous system. | BYOIP |
| Auxiliary Worker | A Worker created locally via the [Workers Vitest integration](https://developers.cloudflare.com/workers/testing/vitest-integration/) that runs in a separate isolate to the test runner, with a different global scope. | Workers |
| backup codes | Backup codes allow restoration of Cloudflare account access outside the normal [two-factor authentication process](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/). A backup code becomes invalid after use. | Fundamentals |
| bandwidth | The maximum rate of data transfer across a network. | Speed |
| binding | [Bindings](https://developers.cloudflare.com/workers/runtime-apis/bindings/) allow your Workers to interact with resources on the Cloudflare Developer Platform. | Workers |
| bit field matching | Matches raw bits in a packet to certain values specified in your rules. | Magic Firewall |
| blocklist | A blocklist is a list of items (usually websites, IP addresses, email addresses, etc.) that are prevented from accessing a system. | WAF |
| bookmark | A bookmark represents the state of a database at a specific point in time.- Bookmarks are lexicographically sortable. Sorting orders a list of bookmarks from oldest-to-newest. | D1 |
| bookmark | A bookmark is a mostly alphanumeric string like `0000007b-0000b26e-00001538-0c3e87bb37b3db5cc52eedb93cd3b96b` which represents a specific state of a SQLite database at a certain point in time. Bookmarks are designed to be lexically comparable: a bookmark representing an earlier point in time compares less than one representing a later point, using regular string comparison. | Durable Objects |
| Border Gateway Protocol (BGP) | The routing protocol for the Internet, which is responsible for picking the most efficient routes to deliver Internet traffic. | BYOIP |
| bot | A software application programmed to do tasks that can be used for good (chatbots, search engine crawlers) or for evil (inventory hoarding, credential stuffing). | Bots |
| bot score | A score from 1 to 99 that indicates how likely that request came from a bot, in which 1 to 29 is likely automated and 30 to 99 is likely human. | Bots |
| bot tags | Additional information about a bot request, such as why Cloudflare has given it a bot score and whether the request came from a verified bot or a category of verified bots. | Bots |
| brotli compression | Brotli compression is a data compression algorithm developed by Google, optimized for web content, and designed to achieve higher compression ratios than traditional algorithms like Gzip. | Speed |
| C3 | [C3](https://developers.cloudflare.com/learning-paths/workers/get-started/c3-and-wrangler/) is a command-line tool designed to help you set up and deploy new applications to Cloudflare. | Workers |
| cache | A temporary storage area where frequently accessed data is stored for quick retrieval. | Cache |
| cache hit | When a requested piece of content is found in the cache, reducing the need to fetch it from the origin server. | Cache |
| cache lock | Cache lock (or mutex) is a mechanism employed by CDN data centers, comprising numerous servers, to prevent the overloading of origin servers. This mechanism ensures that only one server can request a specific file from the origin at any given time, facilitating efficient coordination among the servers. | Cache |
| cache miss | When a requested piece of content is not found in the cache, requiring the server to fetch it from the origin server. | Cache |
| cached bandwidth (cached egress bandwidth) | The amount of bandwidth served from Cloudflare without hitting the origin server. Cached bandwidth is the sum of all `EdgeResponseBytes` where `CacheCacheStatus` equals `hit`, `stale`, `updating`, `ignored`, or `revalidated`. | Cache |
| cached requests | The number of requests served from Cloudflare without having to hit the origin server. Cached requests are the sum of all requests where `CacheCacheStatus` equals `hit`, `stale`, `updating`, `ignored`. This does not include `revalidated` since the request had to be sent to the origin server. | Cache |
| cacheTtl | CacheTtl is a parameter that defines the length of time in seconds that a KV result is cached in the global network location it is accessed from. | KV |
| caching | The process of storing copies of files or data in a cache to accelerate future requests. | Cache |
| CAPTCHA | A CAPTCHA test is designed to determine if an online user is really a human and not a bot. CAPTCHA is an acronym that stands for "Completely Automated Public Turing test to tell Computers and Humans Apart." | Turnstile |
| captive portal | A login screen shown to users when they connect to a public Wi-Fi. Captive portals typically occur in places such as airports, cafes, and hotels. | Cloudflare One |
| certificate | SSL certificates enable encryption over HTTPS for traffic between a client and a website. SSL certificates contain the website's public key and the website's identity along with related information. Devices attempting to communicate with the origin web server reference the SSL certificate to obtain the public key and verify the server's identity. Cloudflare provides a [Universal SSL certificate](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/) for each active Cloudflare domain. | SSL/TLS |
| Certificate Authority (CA) | A CA is a trusted third party that provides SSL certificates for encrypting network traffic. | SSL/TLS |
| certificate packs | Certificate packs allow Cloudflare to fallback to a different SSL certificate for browsers that do not support the latest standards. Certificate packs allow Custom SSL certificates to contain different signature algorithms for the same hostnames listed within the SSL certificate without taking up additional Custom SSL certificate quota for your Cloudflare account. | SSL/TLS |
| certificate pinning | A security mechanism used to prevent on-path attacks on the Internet by hardcoding information about the certificate that the application expects to receive. If the wrong certificate is received, even if it is trusted by the system, the application will refuse to connect. | SSL/TLS |
| Certification Authority Authorization (CAA) record | A CAA record declares which CAs are allowed to issue an SSL certificate for a domain. | SSL/TLS |
| cf-aig-backoff | Header to customize the backoff type for [request retries](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-retries) of a request. | AI Gateway |
| cf-aig-cache-key | The [cf-aig-cache-key-aig-cache-key](https://developers.cloudflare.com/ai-gateway/features/caching/#custom-cache-key-cf-aig-cache-key) let you override the default cache key in order to precisely set the cacheability setting for any resource. | AI Gateway |
| cf-aig-cache-status | [Status indicator for caching](https://developers.cloudflare.com/ai-gateway/features/caching/#default-configuration), showing if a request was served from cache. | AI Gateway |
| cf-aig-cache-ttl | Specifies the [cache time-to-live for responses](https://developers.cloudflare.com/ai-gateway/features/caching/#cache-ttl-cf-aig-cache-ttl). | AI Gateway |
| cf-aig-collect-log | The [cf-aig-collect-log](https://developers.cloudflare.com/ai-gateway/observability/logging/#collect-logs-cf-aig-collect-log) header allows you to bypass the default log setting for the gateway. | AI Gateway |
| cf-aig-custom-cost | Allows the [customization of request cost](https://developers.cloudflare.com/ai-gateway/configuration/custom-costs/#custom-cost) to reflect user-defined parameters. | AI Gateway |
| cf-aig-event-id | [cf-aig-event-id](https://developers.cloudflare.com/ai-gateway/evaluations/add-human-feedback-api/#3-retrieve-the-cf-aig-log-id) is a unique identifier for an event, used to trace specific events through the system. | AI Gateway |
| cf-aig-log-id | The [cf-aig-log-id](https://developers.cloudflare.com/ai-gateway/evaluations/add-human-feedback-api/#3-retrieve-the-cf-aig-log-id) is a unique identifier for the specific log entry to which you want to add feedback. | AI Gateway |
| cf-aig-max-attempts | Header to customize the number of max attempts for [request retries](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-retries) of a request. | AI Gateway |
| cf-aig-metadata | [Custom metadata](https://developers.cloudflare.com/ai-gateway/configuration/custom-metadata/)allows you to tag requests with user IDs or other identifiers, enabling better tracking and analysis of your requests. | AI Gateway |
| cf-aig-request-timeout | Header to trigger a fallback provider based on a [predetermined response time](https://developers.cloudflare.com/ai-gateway/configuration/fallbacks/#request-timeouts) (measured in milliseconds). | AI Gateway |
| cf-aig-retry-delay | Header to customize the retry delay for [request retries](https://developers.cloudflare.com/ai-gateway/configuration/request-handling/#request-retries) of a request. | AI Gateway |
| cf-aig-skip-cache | Header to [bypass caching for a specific request](https://developers.cloudflare.com/ai-gateway/features/caching/#skip-cache-cf-aig-skip-cache). | AI Gateway |
| cf-aig-step | [cf-aig-step](https://developers.cloudflare.com/ai-gateway/configuration/fallbacks/#response-headercf-aig-step) identifies the processing step in the AI Gateway flow for better tracking and debugging. | AI Gateway |
| cf-cache-ttl | Deprecated: This header is replaced by `cf-aig-cache-ttl`. It specifies cache time-to-live. | AI Gateway |
| cf-skip-cache | Deprecated: This header is replaced by `cf-aig-skip-cache`. It bypasses caching for a specific request. | AI Gateway |
| CGNAT IP | A unique, virtual IP address assigned to each WARP device from the `100.96.0.0/12` range. You can view the CGNAT IP for a device in **Team & Resources** > **Devices** > **Virtual IPv4/IPv6**. | Cloudflare One |
| Challenge solve rate (CSR) | The percentage of issued challenges that were solved. | Bots |
| CIDR | CIDR stands for Classless Inter-Domain Routing. CIDR often refers to CIDR notation, which is an IP address represented as a series of four 8-bit octets, separated by dots (e.g., 192.168.1.1). Additionally, CIDR notation includes a suffix that indicates the number of bits used for the network portion of the address. The format is typically written as "/X," where X is the number of bits in the network portion. | Fundamentals |
| cipher suite | A set of encryption algorithms for establishing a secure communications connection. There are several cipher suites in wide use, and a client and server agree on the cipher suite to use when establishing the TLS connection. Support of multiple cipher suites allows compatibility across various clients. | SSL/TLS |
| cloud | A network of remote servers used to store and maintain data. | Fundamentals |
| Cloudflare Access | Cloudflare Access replaces corporate VPNs with Cloudflare's network. It verifies attributes such as identity and device posture to grant users secure access to internal tools. | Cloudflare One |
| Cloudflare Browser Isolation | Cloudflare Browser Isolation seamlessly executes active webpage content in a secure isolated browser to protect users from zero-day attacks, malware, and phishing. | Cloudflare One |
| Cloudflare CASB | Cloudflare CASB provides comprehensive visibility and control over SaaS apps to prevent data leaks and compliance violations. It helps detect insider threats, shadow IT, risky data sharing, and bad actors. | Cloudflare One |
| Cloudflare Dashboard | [Cloudflare Dashboard](https://developers.cloudflare.com/workers-ai/get-started/dashboard/) is a web-based interface that allows users to manage Workers AI services, including model deployment and monitoring. | Workers AI |
| Cloudflare Data Loss Prevention (DLP) | Cloudflare [Data Loss Prevention](https://www.cloudflare.com/learning/access-management/what-is-dlp/) (DLP) allows you to scan your web traffic and SaaS applications for the presence of sensitive data such as social security numbers, financial information, secret keys, and source code. | Cloudflare One |
| Cloudflare DEX | Cloudflare Digital Experience Monitoring (DEX) provides visibility into device, network, and application performance across your Zero Trust Organization. | Cloudflare One |
| Cloudflare Gateway | Cloudflare Gateway is a modern next-generation firewall between your user, device, or network and the public Internet. It includes DNS filtering to inspect and apply policies to all Internet-bound DNS queries. | Cloudflare One |
| Cloudflare One | The name for Cloudflare's Secure Access Service Edge (SASE) platform, which includes Zero Trust and network services. | Cloudflare One |
| Cloudflare One Agent | The name of the Cloudflare WARP client app on iOS and Android devices. | Cloudflare One |
| Cloudflare Tunnel | Cloudflare Tunnel uses software agents (`cloudflared` or WARP Connector) to establish a secure connection between a private network and Cloudflare. | Cloudflare One |
| Cloudflare Zero Trust | Cloudflare Zero Trust provides the power of Cloudflare's global network to your internal teams and infrastructure. It empowers users with secure, fast, and seamless access to any device on the Internet. | Cloudflare One |
| cloudflared | The software powering Cloudflare Tunnel. It runs on origin servers to connect applications or private networks to Cloudflare. | Cloudflare One |
| cloudflared replica | An additional instance of `cloudflared` that points to the same Cloudflare Tunnel. It ensures that your network remains online in case a single host running `cloudflared` goes down. | Cloudflare One |
| code example | A code example illustrates how to use a programming element to implement specific functionality | Fundamentals |
| compression | The process of reducing the size of files or data to speed up their transfer over the network. | Speed |
| consumer | A consumer is the term for a client that is subscribing to or consuming messages from a queue. | Queues |
| content delivery network (CDN) | A geographically distributed group of servers which work together to provide fast delivery of Internet content. | Fundamentals |
| content object | A content object is any binary part of a request body (as detected by Cloudflare systems) that does not match any of the following content types: `text/html`, `text/x-shellscript`, `application/json`, `text/csv`, or `text/xml`. | WAF |
| content security policy (CSP) | An added layer of security that helps detect and mitigate certain types of attacks such as cross-site scripting (XSS) attacks. | Fundamentals |
| Context Window | In generative AI, the context window is the sum of the number of input, reasoning, and completion or response tokens a model supports. You can find the context window limit on each [model page](https://developers.cloudflare.com/workers-ai/models/). | Workers AI |
| core web vitals | Core web vitals are a set of user-centric performance metrics, including Largest Contentful Paint (LCP), Cumulative Layout Shift (CLS), and First Input Delay (FID), used by Google to assess the overall user experience of a webpage. | Speed |
| CPU time | [CPU time](https://developers.cloudflare.com/workers/platform/limits/#cpu-time) is the amount of time the central processing unit (CPU) actually spends doing work, during a given request. | Workers |
| credential stuffing | Credential stuffing is the automated injection of stolen username and password pairs (known as "credentials") into website login forms, trying to gain access to user accounts. | WAF |
| credit | An amount applied to a specific Cloudflare account as credit for recurring subscriptions or plan payments. The Cloudflare billing system automatically applies credits in the next billing cycle. | Fundamentals |
| Cron Triggers | [Cron Triggers](https://developers.cloudflare.com/workers/configuration/cron-triggers/) allow users to map a cron expression to a Worker using a [`scheduled()` handler](https://developers.cloudflare.com/workers/runtime-apis/handlers/scheduled/) that enables Workers to be executed on a schedule. | Workers |
| cumulative layout shift (CLS) | Cumulative layout shift (CLS) is a web performance metric that quantifies the visual stability of a webpage by measuring the sum of unexpected layout shifts of elements during the page's loading and rendering process. | Speed |
| D1 | [D1](https://developers.cloudflare.com/d1/) is Cloudflare's managed, serverless database with SQLite's SQL semantics, built-in disaster recovery, and Worker and HTTP API access. | Workers AI |
| D1 | [D1](https://developers.cloudflare.com/d1/) is Cloudflare's native serverless database. | Workers |
| daemon | A program that performs tasks without active management or maintenance. | Cloudflare One |
| data center | A physical location where servers run and other IT operations are hosted. | Fundamentals |
| data packet | A data packet is a unit of data consisting of user and control information. Information in a network is broken down into packets, that might follow different paths to their final destination. | Magic WAN |
| debugging | The process of identifying and resolving errors or issues within software applications or systems, often facilitated by analyzing log data. | Logs |
| demo application | A demo application is a functional application in GitHub that you can clone and deploy on your own. | Fundamentals |
| denial-of-service (DoS) attack | A DoS attack is a type of cyber attack in which an attacker aims to render a computer or other device unavailable to its intended users by interrupting the device's normal functioning. | Fundamentals |
| deployment | [Deployments](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/#deployments) track the version(s) of your Worker that are actively serving traffic. | Workers |
| deprecation | Deprecation in software development involves officially labeling a feature as outdated. While a deprecated software feature remains within the software, users are warned and encouraged to adopt alternatives. Eventually, deprecated features may be removed. This approach ensures backward compatibility and gives programmers time to update their code. | Logs |
| detection ID | Static rules that are used to detect predictable bot behavior with no overlap with human traffic. | Bots |
| device posture | A way to evaluate the security of a user's device, for example by verifying its serial number or checking if it has the latest software updates. | Cloudflare One |
| device profile | A collection of WARP client settings applied to a specific set of devices in your organization. | Cloudflare One |
| disposition | Represents Area 1's evaluation of a specific message. For example, after evaluating an email it may get a disposition of `malicious`. Email messages with this disposition exhibit characteristics typical of malicious emails. | Area 1 |
| distributed denial-of-service (DDoS) attack | A DDoS attack is a malicious attempt to disrupt normal traffic of a targeted server, service, or network by overwhelming the target or its surrounding infrastructure with a flood of Internet traffic. | Fundamentals |
| DNS filtering | DNS filtering uses the Domain Name System to block malicious websites and filter out harmful content, enhancing security and access control. | Cloudflare One |
| DNS location | DNS locations are a collection of DNS endpoints which can be mapped to physical entities such as offices, homes, or data centers. | Cloudflare One |
| DNS over HTTPS | DNS over HTTPS (DoH) is a standard for encrypting DNS traffic via the HTTPS protocol, preventing tracking and spoofing of DNS queries. | DNS |
| DNS over TLS | DNS over TLS (DoT) is a standard for encrypting DNS traffic using its own port (`853`) and TLS encryption. | DNS |
| DNS record | DNS records are instructions that live in authoritative DNS servers and provide information about a domain, including what IP address is associated with that domain and how to handle requests for that domain. | DNS |
| DNS server | DNS servers translate human-readable domain names into IP addresses, eliminating the need to remember complex IP addresses. | DNS |
| DNS zone | A portion of the DNS namespace that is managed by a specific organization or administrator. | DNS |
| DoH subdomain | A unique DoH subdomain for each DNS location in Cloudflare One used in WARP client settings. | Cloudflare One |
| domain | The domain name of your application on Cloudflare. | Fundamentals |
| domain control validation (DCV) | Process by which a certificate authority (CA) can verify domain ownership before issuing an SSL/TLS certificate. | SSL/TLS |
| Domain Name System (DNS) | The Domain Name System (DNS) is the phonebook of the Internet. DNS translates domain names to IP addresses. | DNS |
| downtime | Downtime is the duration during which a system, service, or equipment is not operational or unavailable for use. | Waiting Room |
| Durable Execution | "Durable Execution" is a programming model that allows applications to execute reliably, automatically persist state, retry, and be resistant to errors caused by API, network or even machine/infrastructure failures. Cloudflare Workflows provide a way to build and deploy applications that align with this model. | Workflows |
| Durable Object | A Durable Object is an individual instance of a Durable Object class. A Durable Object is globally unique (referenced by ID), provides a global point of coordination for all methods/requests sent to it, and has private, persistent storage that is not shared with other Durable Objects within a namespace. | Durable Objects |
| Durable Object class | The JavaScript class that defines the methods (RPC) and handlers (`fetch`, `alarm`) as part of your Durable Object, and/or an optional `constructor`. All Durable Objects within a single namespace share the same class definition. | Durable Objects |
| Durable Objects | The product name, or the collective noun referring to more than one Durable Object. | Durable Objects |
| Durable Objects | [Durable Objects](https://developers.cloudflare.com/durable-objects/) is a globally distributed coordination API with strongly consistent storage. | Workers |
| duration | [Duration](https://developers.cloudflare.com/workers/platform/limits/#duration) is a measurement of wall-clock time — the total amount of time from the start to end of an invocation of a Worker. | Workers |
| dynamic content | Dynamic content refers to website content that changes based on factors specific to the user such as time of visit, location, and device. News websites or social media are examples of this type of content. For this type of website, content has to be fetched from the origin server every time it is requested. | Cache |
| edge certificate | The SSL/TLS certificates that Cloudflare presents to clients visiting your website or application.Because of [how Cloudflare works](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/), there can actually be [two certificates involved in a single request](https://developers.cloudflare.com/ssl/concepts/): an edge certificate and an origin certificate. | SSL/TLS |
| edge response status code | HTTP response code sent from Cloudflare to the client (end user). The Cloudflare dashboard **Analytics** app uses the edge response status code. | Fundamentals |
| edge server | A server located at the edge of a network, typically within a CDN, that serves content to end-users. | Cache |
| EDNS Client Subnet (ECS) | ECS is a DNS extension that enables recursive DNS resolvers to include client IP address information in their DNS queries.Not all resolvers use ECS but, if they do, usually a part of the IP address is omitted. Sending ECS headers is generally intended to reduce latency and speed up content delivery in connection to [CDNs](https://developers.cloudflare.com/glossary/?term=cdn) and [load balancers](https://www.cloudflare.com/learning/performance/what-is-load-balancing/). The ECS mechanism is specified in [RFC 7871](https://www.rfc-editor.org/rfc/rfc7871.html). | DNS |
| encryption algorithm | An encryption algorithm is a set of mathematical operations performed on data to ensure the data is only understood by the intended recipient. | SSL/TLS |
| endpoint | Any service or hardware that intercepts and processes incoming public or private traffic.Examples of endpoints include origins, hostnames, private or public IP addresses, virtual IP addresses (VIPs), servers, and other dedicated hardware boxes. | Load Balancing |
| environment | [Environments](https://developers.cloudflare.com/workers/wrangler/environments/) allow you to deploy the same Worker application with different configuration for each environment. Only available for use with a [Wrangler configuration file](https://developers.cloudflare.com/workers/wrangler/configuration/). | Workers |
| environment variable | [Environment variables](https://developers.cloudflare.com/workers/configuration/environment-variables/) are a type of binding that allow you to attach text strings or JSON values to your Worker. | Workers |
| Environment Variables | [Environment Variables](https://developers.cloudflare.com/workers-ai/configuration/bindings/) are dynamic values that can be used within Workers to manage configuration settings, including those related to AI integrations. | Workers AI |
| equal-cost multi-path routing | A technique that uses hashes calculated from packet data to determine the route chosen. | Magic WAN |
| error page | An error page is a webpage shown to users when they try to access a specific webpage or resource that is unavailable due to a server error, broken link, or other issues. It typically includes details about the encountered error and offers potential solutions or guidance to help users navigate the problem. | Waiting Room |
| event | An occurrence or happening that is significant and worthy of being recorded in a log. | Logs |
| Event | The event that triggered the Workflow instance. A `WorkflowEvent` may contain optional parameters (data) that a Workflow can operate on. | Workflows |
| example | Hello, world! You can use **Markdown** features inside of your `tooltips`. | Style Guide |
| Extended Validation (EV) certificate | EV certificates provide maximum trust to visitors, but require the most validation effort by the CA. EV certificates show the name of the company or organization in the address bar of the visitor’s browser. An EV certificate requires additional documentation by the company or organization in order for the CA to approve the certificate. | SSL/TLS |
| feature | A feature is a setting in the Cloudflare dashboard that corresponds to functionality within a Cloudflare product or API. | Fundamentals |
| Fine-Tuning | [Fine-Tuning](https://developers.cloudflare.com/workers-ai/fine-tunes/) is a general term for modifying an AI model by continuing to train it with additional data. | Workers AI |
| firewall | A firewall is a security system that monitors and controls network traffic based on a set of security rules. | WAF |
| firewall-as-a-service | Also known as cloud firewall. A security product that is hosted in the cloud. | Magic Firewall |
| first contentful paint (FCP) | First contentful paint (FCP) is a web performance metric that measures the time it takes for the first piece of content to be rendered on the screen during the loading of a web page. | Speed |
| first input delay (FID) | First input delay (FID) is a web performance metric that measures the delay between a user's first interaction with a page (for example, clicking a button) and the moment the browser responds, indicating the page's interactivity and responsiveness. | Speed |
| fleet | A fleet is a collection of user devices. All devices in a fleet have WARP installed and are connected to a [Zero Trust Organization](https://developers.cloudflare.com/cloudflare-one/setup/#create-a-zero-trust-organization). | Cloudflare One |
| flow data | Represents records of communication between devices. There are a number of flow data protocols, such as NetFlow or sFlow. | Magic Network Monitoring |
| FTP (File Transfer Protocol) | A standard network protocol used for transferring files from one host to another over a TCP-based network. | Spectrum |
| FTPS (File Transfer Protocol Secure) | An extension of FTP that adds support for the Transport Layer Security (TLS) or Secure Sockets Layer (SSL) cryptographic protocols. | Spectrum |
| Function Calling | [Function Calling](https://developers.cloudflare.com/workers-ai/function-calling/) enables people to take Large Language Models (LLMs) and use the model response to execute functions or interact with external APIs. | Workers AI |
| GRE tunnel | Stands for generic routing encapsulation. It is a protocol wrapping one data packet within another type of data packet. This is useful for enabling protocols that are not normally supported by a network. | Magic WAN |
| handler | [Handlers](https://developers.cloudflare.com/workers/runtime-apis/handlers/) are methods on Workers that can receive and process external inputs, and can be invoked from outside your Worker. | Workers |
| health check | Requests issued by a monitor at regular interval and — depending on the monitor settings — return a **pass** or **fail** value to make sure an endpoint is still able to receive traffic.Each health monitor request is trying to answer two questions:1) **Is the endpoint offline?**: Does the endpoint respond to the health monitor request at all? If so, does it respond quickly enough (as specified in the monitor's **Timeout** field)?
2) **Is the endpoint working as expected?**: Does the endpoint respond with the expected HTTP response codes? Does it include specific information in the response body?If the answer to either of these questions is "No", then the endpoint fails the health monitor request. | Load Balancing |
| Hops | Hops refer to the stops an email makes as it travels from the sender to the recipient. | Cloudflare One |
| hostname | The name given to a server or node on a network, often the public DNS name of a server. | DNS |
| HTTP request | An HTTP request is the way Internet communications platforms such as web browsers ask for the information they need to load a website. | Fundamentals |
| ICMP | Internet Control Message Protocol (ICMP) is used by network devices to send error messages and other operational information. ICMP is useful for diagnostic purposes, for example. | Magic WAN |
| identity provider | An identity provider (IdP) stores and manages users' digital identities, enabling single sign-on and authentication for multiple applications. | Cloudflare One |
| idle connection | When a TCP connection is in an idle state, it means that the connection has been established, but neither endpoint is sending any data. In the context of HTTP, an idle connection is when an established connection between a client and a server is not currently transmitting any HTTP requests or responses. | Fundamentals |
| iFrame | An iFrame, short for Inline Frame, is an HTML element used to embed and display external content within a webpage, allowing the incorporation of another document or web page seamlessly within the main document. | Waiting Room |
| Inference | [Inference](https://developers.cloudflare.com/workers-ai/fine-tunes/public-loras/#running-inference-with-public-loras) refers to the process of using a trained machine learning model to make predictions or generate outputs based on new data. | Workers AI |
| initial resolved IP | A unique, ephemeral IP address that Gateway assigns to DNS queries when filtering network traffic by hostname. The IP is randomly selected from the `100.80.0.0/16` (IPv4) or `2606:4700:0cf1:4000::/64` (IPv6) range. | Cloudflare One |
| input gate | While a storage operation is executing, no events shall be delivered to a Durable Object except for storage completion events. Any other events will be deferred until such a time as the object is no longer executing JavaScript code and is no longer waiting for any storage operations. We say that these events are waiting for the "input gate" to open. | Durable Objects |
| instance | See "Durable Object". | Durable Objects |
| instance | A specific instance (running, paused, errored) of a Workflow. A Workflow can have a potentially infinite number of instances. | Workflows |
| interaction to next paint (INP) | Interaction to next paint (INP) is a web performance metric that measures the time it takes for a web page to become interactive and respond to user input after the initial paint, providing insights into the user experience during the interaction phase of page loading. | Speed |
| intermediate certificate | For security purposes, CAs issue intermediate certificates for signing website certificates. Intermediate certificates provide a means for the CA to revoke a single intermediate certificate, thus affecting only a small subset of website certificates. | SSL/TLS |
| Internet | The Internet is a global system of computer networks that provides a wide range of information and communication facilities. | Fundamentals |
| Internet key exchange (IKE) | The protocol Cloudflare uses to create the IPsec tunnel between Magic WAN and the customer's device. | Magic WAN |
| Internet Routing Registry (IRR) | A globally distributed database of routing information which contains announced routes and routing policies in a common format. Network operators use this information, as well as [RPKI](https://developers.cloudflare.com/byoip/concepts/route-filtering-rpki/), to configure backbone routers. | BYOIP |
| IP address | IP stands for Internet Protocol, which is the set of rules that makes it possible for devices to communicate over the Internet. With billions of people accessing the Internet every day, unique identifiers are necessary to keep track of who is doing what. The Internet Protocol solves this by assigning IP numbers to every device accessing the Internet. Every assigned number is an IP address. | Fundamentals |
| IP spoofing | IP spoofing is the creation of Internet Protocol (IP) packets which have a modified source address to hide the identity of the sender, impersonate another computer system, or both. | DDoS Protection |
| IPsec tunnel | Stands for Internet Protocol secure. It is a group of protocols for securing connections between devices, by encrypting IP packets. | Magic WAN |
| isolate | [Isolates](https://developers.cloudflare.com/workers/reference/how-workers-works/#isolates) are lightweight contexts that provide your code with variables it can access and a safe environment to be executed within. | Workers |
| JA3 fingerprint | JA3 and JA4 fingerprints profile specific SSL/TLS clients across different destination IPs, Ports, and X509 certificates. | Bots |
| JSON web token | A compact way to securely transmit information between parties as a JSON object, often used for authentication. | Cloudflare One |
| JSON web token (JWT) | A common authentication and authorization method used in web applications and APIs. | Rules |
| JSON-friendly | JSON-friendly refers to data or formats that are easily and naturally represented in JSON (JavaScript Object Notation), a lightweight data interchange format, without requiring complex transformations or modifications. | Waiting Room |
| KV | [Workers KV](https://developers.cloudflare.com/kv/) is Cloudflare's key-value data storage. | Workers |
| KV API | API methods part of Storage API that support persisting key-value data. | Durable Objects |
| KV namespace | A KV namespace is a key-value database replicated to Cloudflare’s global network. A KV namespace must require a binding and an id. | KV |
| largest contentful paint (LCP) | Largest contentful paint (LCP) is a web performance metric that measures the time it takes for the largest content element to be fully rendered and visible to the user during the loading of a web page. | Speed |
| latency | The delay between a user action and the corresponding response from the system. | Speed |
| layer 3 | The network layer in the OSI model, responsible for logical addressing, routing, and forwarding of data between devices on different networks. | Spectrum |
| layer 4 | The transport layer in the OSI model, managing end-to-end communication, error-checking, and flow control. | Spectrum |
| lazy loading | Loading images or other resources only when they are about to be displayed, rather than loading everything at once. | Speed |
| leaked credentials | Leaked credentials refers to sensitive authentication information disclosed in some way (for example, due to misconfigurations, data breaches, or simple human error), allowing other parties to gain access to digital resources.Credentials may include usernames, passwords, API keys, authentication tokens, or private keys. | WAF |
| legitimate traffic | Legitimate traffic refers to authorized and permissible network activity, data transmissions, or communications that adhere to established norms and rules within a given system or network. | Waiting Room |
| letter of agency | Sometimes referred to as a Letter of Authorization. A document that authorizes Cloudflare to advertise your prefixes. This is required so transit providers can accept the routes Cloudflare advertises on your behalf. | Magic Transit |
| LLM | A machine learning model that can comprehend and generate human language text. It works by analyzing massive data sets of language. | WAF |
| locally-managed tunnel | A Cloudflare Tunnel that was created by running `cloudflared tunnel create <NAME>` on the command line. Tunnel configuration is stored in your local `cloudflared` directory. | Cloudflare One |
| log | A chronological record of events, actions, or transactions, typically used for tracking and troubleshooting purposes. | Logs |
| log file | A file containing a collection of log entries, usually stored in a structured or semi-structured format. | Logs |
| logging | The process of recording events, actions, or transactions in a log. | Logs |
| LoRA Adapters | [LoRA Adapters](https://developers.cloudflare.com/workers-ai/fine-tunes/loras/) (Low-Rank Adaptation adapters) are used in machine learning to fine-tune models efficiently by adjusting a small number of parameters, allowing for customization of AI models in Workers AI.[Public LoRA Adapters](https://developers.cloudflare.com/workers-ai/fine-tunes/public-loras/) are pre-trained Low-Rank Adaptation adapters available for public use. | Workers AI |
| managed network | A network location, such as an office, that is associated with a specific WARP client device profile. | Cloudflare One |
| maximum segment size (MSS) | MSS limits the size of packets, or small chunks of data, that travel across a network, such as the Internet. | Magic WAN |
| Maximum Tokens | In generative AI, the user-defined property `max_tokens` defines the maximum number of tokens at which the model should stop responding. This limit cannot exceed the context window. | Workers AI |
| MCP client | A Model Context Protocol (MCP) client is an AI program that can request information and receive responses from an MCP server. Examples of MCP clients include Claude Desktop, Cursor AI, and Windsurf. | Cloudflare One |
| MCP server | A web application that allows AI agents to access third-party data sources and APIs using the Model Context Protocol (MCP). For example, you can use an MCP server to connect an AI assistant to your Google Drive account. | Cloudflare One |
| MCP server portal | A web application in Cloudflare One that serves as a gateway to multiple MCP servers. | Cloudflare One |
| MCP server tool | An integration provided by an MCP server which allows an AI agent to perform a limited set of actions on a third-party system. | Cloudflare One |
| MDM file | A Mobile Device Management (MDM) file is a configuration file that allows organizations to manage the software, settings, and certificates installed on their devices. | Cloudflare One |
| member or user | A member or user is an email account in Cloudflare that you can grant access to your organization account. Members belonging to multiple accounts can select which account to manage via the Cloudflare dashboard. | Fundamentals |
| Merchant of Record | The entity who facilitates "buying and selling". For pay per crawl, Cloudflare is the merchant of record. | AI Crawl Control |
| metadata | A metadata is a serializable value you append to each KV entry. | KV |
| MFA | Multi-factor authentication (MFA) checks multiple aspects of a user's identity, not only their username and password, before allowing them access to an application. | Cloudflare One |
| migration | A Durable Object migration is a mapping process from a class name to a runtime state. Initiate a Durable Object migration when you need to:- Create a new Durable Object class.
- Rename a Durable Object class.
- Delete a Durable Object class.
- Transfer an existing Durable Objects class. | Durable Objects |
| minification | The process of removing unnecessary characters from code (such as whitespace or comments) to reduce file size and improve loading times. | Speed |
| mitigated request | A request to which Cloudflare applied a terminating action such as block or challenge. | WAF |
| Model Catalog | [Model Catalog](https://developers.cloudflare.com/workers-ai/models/) is a curated collection of AI models available within Workers AI, providing developers with a variety of pre-trained models for different tasks. | Workers AI |
| module Worker | Refers to a Worker written in [module syntax](https://developers.cloudflare.com/workers/reference/migrate-to-module-workers/). | Workers |
| monitor | A monitor issues health monitor requests at regular intervals to evaluate the health of each endpoint within a [pool](https://developers.cloudflare.com/load-balancing/pools/).When a pool [becomes unhealthy](https://developers.cloudflare.com/load-balancing/understand-basics/health-details/), your load balancer takes that pool out of the endpoint rotation. | Load Balancing |
| MQTT (Message Queuing Telemetry Transport) | A lightweight, publish-subscribe messaging protocol often used for communication in the Internet of Things (IoT) and other resource-constrained scenarios. | Spectrum |
| mTLS (mutual TLS) | [Mutual TLS (mTLS)](https://www.cloudflare.com/learning/access-management/what-is-mutual-tls/) authentication is a common security practice that uses client certificates to ensure traffic between client and server is bidirectionally secure and trusted. mTLS also allows requests that do not authenticate via an identity provider — such as Internet-of-things (IoT) devices — to demonstrate they can reach a given resource. | SSL/TLS |
| nameserver | A nameserver is a dedicated server that translates human readable hostnames (`www.example.com`) into IP addresses.Nameservers like root servers, TLD servers, and [authoritative nameservers](https://developers.cloudflare.com/dns/nameservers/) are fundamental components of the Domain Name System (DNS). | DNS |
| namespace | A logical collection of Durable Objects that all share the same Durable Object (class) definition. A single namespace can have (tens of) millions of Durable Objects. Metrics are scoped per namespace.- The binding name of the namespace (as it will be exposed inside Worker code) is defined in the Wrangler file under the `durable_objects.bindings.name` key. Note that the binding name may not uniquely identify a namespace within an account. Instead, each namespace has a unique namespace ID, which you can view from the Cloudflare dashboard.
- You can instantiate a unique Durable Object within a namespace using [Durable Object namespace methods](https://developers.cloudflare.com/durable-objects/api/namespace/#methods). | Durable Objects |
| NetFlow | Network protocol developed by Cisco to collect and monitor network traffic flow data. | Magic Network Monitoring |
| non-browser traffic | Non-browser traffic refers to data exchanges and communication occurring between devices or systems that do not involve web browsers, such as a mobile app or web apps. | Waiting Room |
| OAuth | A protocol for authorizing users, allowing them to perform actions and view data on different platforms without sharing credentials. | Cloudflare One |
| OIDC | OpenID Connect (OIDC) is an identity authentication protocol built on top of OAuth 2.0. It is used verifying user identity and obtaining basic profile information. | Cloudflare One |
| on-ramp | Refers to a way of connecting a business network to Cloudflare. Examples of on-ramps, or ways to connect to Cloudflare, are Anycast GRE tunnels, Anycast IPsec tunnels, Cloudflare Network Interconnect (CNI), Cloudflare Tunnel, and WARP. | Cloudflare One |
| on-ramp | Refers to a way of connecting a business network to Cloudflare. Examples of on-ramps, or ways to connect to Cloudflare, are Anycast GRE tunnels, Anycast IPsec tunnels, Cloudflare Network Interconnect (CNI), Cloudflare Tunnel, and WARP. | Magic WAN |
| Organization Validated (OV) certificate | OV certificates are used by corporations or governments to portray an extra layer of confidence for their visitors. Rather than just validating domain ownership, the CA also validates the company’s registration using qualified independent information sources. The organization’s name is listed in the certificate. | SSL/TLS |
| origin | [Origin](https://www.cloudflare.com/learning/cdn/glossary/origin-server/) generally refers to the web server behind Cloudflare where your application is hosted. | Workers |
| origin bandwidth (origin egress bandwidth) | The amount of data transferred from the origin server to Cloudflare within a certain period of time. Origin bandwidth is the sum of all `EdgeResponseBytes` where `OriginResponseStatus` does not equal `0`. | Cache |
| origin certificate | A Cloudflare Origin Certificate is a free SSL/TLS certificate issued by Cloudflare that can be installed on your origin server to facilitate making sure your data is encrypted in transit from Cloudflare to your origin server using HTTPS. | SSL/TLS |
| origin request | An origin request is a request served from the origin server. | Fundamentals |
| origin response status code | An origin response status code is an HTTP response code sent from the origin server to Cloudflare. | Fundamentals |
| origin server | The original server where the web content is hosted before it is distributed to edge servers in a CDN. | Cache |
| origin/host server | The server where the website content is hosted. | Fundamentals |
| OSI model (Open Systems Interconnection model) | A conceptual framework that standardizes the functions of a telecommunication or computing system into seven abstraction layers. | Spectrum |
| output gate | When a storage write operation is in progress, any new outgoing network messages will be held back until the write has completed. We say that these messages are waiting for the "output gate" to open. If the write ultimately fails, the outgoing network messages will be discarded and replaced with errors, while the Durable Object will be shut down and restarted from scratch. | Durable Objects |
| PAC file | A file containing a JavaScript function which can instruct a browser to forward traffic to a proxy server instead of directly to the destination server. | Cloudflare One |
| page load time | The time it takes for a web page to fully load in a user's browser. | Speed |
| Pages | [Cloudflare Pages](https://developers.cloudflare.com/pages/) is Cloudflare's product offering for building and deploying full-stack applications. | Workers |
| paranoia level | Classifies rules of the OWASP managed ruleset according to their aggressiveness. | WAF |
| partial setup | Also known as CNAME setup, a partial setup allows you to use Cloudflare's reverse proxy without using Cloudflare for your authoritative nameservers. | DNS |
| phishing | The practice of trying to acquire sensitive data through fraudulent emails or other means. Usually, the perpetrators try to pass for a legitimate company when asking for sensitive data. | Area 1 |
| plan | Plans distinguish the breadth of Cloudflare features accessible to a specific domain. Plan options include [Free, Pro, Business, or Enterprise](https://www.cloudflare.com/plans/). | Fundamentals |
| policy | A set of rules that regulate network activity, such as login access and website reachability. | Cloudflare One |
| policy-based routing | Policy-based routing (PBR) is a technique used to make routing decisions based on policies set by your administrador. | Magic Transit |
| pool | Within Cloudflare, pools represent your endpoints and how they are organized. As such, a pool can be a group of several endpoints, or you could also have only one endpoint (an origin server, for example) per pool.If you are familiar with DNS terminology, think of a pool as a “record set,” except Cloudflare only returns addresses that are considered healthy. You can attach health monitors to individual pools for customized monitoring. A pool can have either a single monitor or a monitor group attached — but not both. | Load Balancing |
| prefix | A number that identifies the network portion of an IP address. It tells devices if an IP address is on the same network or not. It is shown as a number after a slash (for example, `/31`) at the end of the IP address.Using an analogy, the prefix is like a street address. If an IP is in the same street, it belongs to the same network of devices. | Magic Transit |
| primary certificate / secondary certificate | Primary and secondary indicates the order in which Custom SSL certificates were uploaded to Cloudflare. The primary certificate is the first certificate added to a pack. The primary certificate defines the hostnames covered by the certificate. | SSL/TLS |
| primary database instance | The primary database instance is the original instance of a database. This database instance only exists in one location in the world. | D1 |
| producer | A producer is the term for a client that is publishing or producing messages on to a queue. | Queues |
| Prompt Engineering | [Prompt Engineering](https://developers.cloudflare.com/workers-ai/guides/prompting/) is the practice of designing and refining input prompts to effectively elicit desired responses from AI models. | Workers AI |
| prompt injection | The process of overwriting the system prompt for a large language model (LLM), which instructs the LLM on how to respond to user input. | WAF |
| Prompt Templates | [Prompt Templates](https://developers.cloudflare.com/workers-ai/guides/prompting/) are predefined structures that guide the input provided to AI models, enhancing consistency and effectiveness in responses. | Workers AI |
| protocol | A protocol is a set of rules governing the exchange or transmission of data between devices. | Fundamentals |
| proxy protocol | A protocol used by network proxies to convey client connection information to the destination server, facilitating proper handling of client requests. | Spectrum |
| proxy read timeout | A proxy read timeout is the maximum amount of time a proxy server waits for a response from the origin server before terminating the connection. | Fundamentals |
| proxy server | The server that sits between the origin server and the client. Cloudflare is a proxy server for example. | Fundamentals |
| proxy status | The proxy status of a DNS record defines whether requests for your domain will route through Cloudflare (`proxied`) or not (`DNS-only`).When a [DNS record is proxied](https://developers.cloudflare.com/dns/proxy-status/), requests are processed according to your configurations, and Cloudflare can optimize, cache, and protect your domain. Refer to [How Cloudflare works](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/) for details. | DNS |
| proxy write timeout | A proxy write timeout is the maximum amount of time a proxy server allows for sending data to the client before terminating the connection. | Fundamentals |
| public key / private key | SSL public and private keys are essentially long strings of characters used for encrypting and decrypting data. Data encrypted with the public key can only be decrypted with the private key, and vice versa. Private keys are kept secret and unshared. | SSL/TLS |
| purge | The process of removing outdated content from the cache to make room for updated content and ensure the delivery of the latest content. | Cache |
| Quarantine policies | Policies that block specific types of emails (usually malicious and suspicious emails), preventing emails from reaching the end-user or the next mail service provider. Emails that are quarantined are reviewed by administrators and potentially released if falsely flagged. | Cloudflare One |
| query planner | A component in a database management system which takes a user query and generates the most efficient plan of executing that query (the query plan). For example, the query planner decides which indices to use, or which table to access first. | D1 |
| queue | A queue is a buffer or list that automatically scales as messages are written to it, and allows a consumer Worker to pull messages from that same queue. | Queues |
| Queues | [Queues](https://developers.cloudflare.com/queues/) integrates with Cloudflare Workers and enables you to build applications that can guarantee delivery. | Workers |
| R2 | [R2](https://developers.cloudflare.com/r2/) is an S3-compatible distributed object storage designed to eliminate the obstacles of sharing data across clouds. | Workers |
| rate limiting | Rate limiting is a technique used in computer systems to control the rate at which requests are processed. It can be used as a security measure to prevent attacks, or to limit resource usage in your origin servers. | WAF |
| RDP | Remote Desktop Protocol (RDP) allows remote desktop connections to a computer, often used on Windows and Mac operating systems. | Cloudflare One |
| read replica | A read replica is an eventually-replicated copy of the primary database instance which only serve read requests. There may be multiple read replicas for a single primary database instance. | D1 |
| real user monitoring (RUM) | Real user monitoring (RUM) is a web performance monitoring technique that collects and analyzes data based on actual user interactions and experiences, providing insights into how users interact with a website or application in real-time. | Speed |
| redirect | URL redirects navigate the user from a source URL to a target URL using a given HTTP status code. URL redirection is also known as URL forwarding. | Fundamentals |
| reference architecture | A reference architecture provides a high-level view of how all or part of the Cloudflare platform is built and how Cloudflare products would fit into a customer's existing infrastructure. | Fundamentals |
| remotely-managed tunnel | A Cloudflare Tunnel whose configuration is stored on Cloudflare rather than on your local machine. You can manage the tunnel in the dashboard under **Networks** > **Connectors** or by using the API. | Cloudflare One |
| render time | The time it takes for a browser to display a fully rendered web page after receiving the necessary resources. | Speed |
| replica lag | The time it takes for the primary database instance to replicate its changes to a specific read replica. | D1 |
| request | A request is a message that is sent between a client, or web browser, to a server. Each request that has been processed through the Cloudflare network generates a record. | Fundamentals |
| Resource Public Key Infrastructure (RPKI) | A cryptographic method of signing records that associate a route with an originating autonomous system number. | BYOIP |
| REST API | [REST API](https://developers.cloudflare.com/workers-ai/get-started/rest-api/) is an application programming interface that allows developers to interact with Workers AI services over HTTP, enabling model management and inference requests. | Workers AI |
| reverse proxy | A server that handles requests on behalf of clients, forwarding them to backend servers and managing tasks like load balancing and security. | Spectrum |
| robots.txt | A text file which lists pages in your website that are off-limits for bots. Well-behaved bots respect this file, but some bots may violate it. You can enforce `robots.txt` with Cloudflare WAF custom rules. | AI Crawl Control |
| roles | Authorize which Cloudflare products and features a member is allowed to access in a Cloudflare account. Learn more about [roles](https://developers.cloudflare.com/fundamentals/manage-members/roles/). | Fundamentals |
| rollback | [Rollbacks](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/rollbacks/) are a way to deploy an older deployment to the Cloudflare global network. | Workers |
| root certificate | A root certificate is generated by a CA and is used to sign certificates. Every browser includes a root store of trusted root certificates. Any certificate signed with the private key of a root certificate is automatically trusted by a browser. | SSL/TLS |
| Route Origin Authorization (ROA) | The RPKI-signed object that states an autonomous system is authorized to originate a particular IP address prefix or set of prefixes. | BYOIP |
| rule characteristics | The set of parameters of a rate limiting rule that define how Cloudflare tracks the rate for the rule. | WAF |
| Rule group | A set of Access rules that can be configured once and then quickly applied across many Access policies. | Cloudflare One |
| SafeSearch | SafeSearch is a feature of search engines that filters explicit or offensive content from search results. | Cloudflare One |
| SAML | Security Assertion Markup Language (SAML) enables single sign-on and authentication for multiple applications. | Cloudflare One |
| sampling | In the context of Magic Network Monitoring, sampling is the process of taking samples of packets for a specific period to identify potential attacks. | Magic Network Monitoring |
| SASE | Secure Access Service Edge (SASE) is a cloud-based security model bundling networking and security functions. | Cloudflare One |
| saved bandwidth (saved egress bandwidth) | The percentage of bandwidth saved by caching on the Cloudflare network. | Cache |
| SCIM | System for Cross-domain Identity Management (SCIM) is an open standard protocol that allows identity providers (such as Okta or Microsoft Entra ID) to synchronize user identity information with cloud applications and services. | Cloudflare One |
| search engine optimization (SEO) | SEO, or search engine optimization, is the practice of optimizing online content to improve its visibility and ranking in search engine results, thereby increasing organic traffic and relevance. | Speed |
| seat | A unique user authenticating to an Access application or enrolling in WARP, | Cloudflare One |
| secret | [Secrets](https://developers.cloudflare.com/workers/configuration/secrets/) are a type of binding that allow you to attach encrypted text values to your Worker. | Workers |
| secret key | The secret key allows communication between your application backend and the Cloudflare Turnstile server to validate the widget response. | Turnstile |
| Secure Sockets Layer (SSL) | SSL was a widely used cryptographic protocol for providing data security for Internet communications. SSL was superseded by TLS; however, most people still refer to Internet cryptographic protocols as SSL. | SSL/TLS |
| SEO crawlers | SEO crawlers, or web crawlers, are automated programs employed by search engines to systematically browse and index web content, gathering information about the structure and relevance of pages to determine search result rankings. | Waiting Room |
| Server Name Indication (SNI) | SNI allows a server to host multiple TLS Certificates for multiple websites using a single IP address. SNI adds the website hostname in the TLS handshake to inform the server which website to present when using shared IPs.Cloudflare uses SNI for all Universal SSL certificates. | SSL/TLS |
| server response time | The time it takes for a server to respond to a request from a user's browser. | Speed |
| Serverless GPUs | [Serverless GPUs](https://developers.cloudflare.com/workers-ai/) are graphics processing units provided by Cloudflare in a serverless environment, enabling scalable and efficient execution of machine learning models without the need for managing underlying hardware. | Workers AI |
| Service Level Agreement (SLA) | An SLA is a contractual obligation for Cloudflare to maintain a specific level of service. Read the [Service Level Agreement (SLA) for the Cloudflare Business plan](https://www.cloudflare.com/business-sla/). Enterprise customers refer to the Enterprise SLA provided with their contract. | Fundamentals |
| service provider (SP) | A service provider (SP) provides federated access to an application for a user from an identity provider (IdP). | Cloudflare One |
| service token | Authentication credentials generated by Cloudflare Access which enable automated systems to access protected applications. | Cloudflare One |
| service Worker | Refers to a Worker written in [service worker](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) [syntax](https://developers.cloudflare.com/workers/reference/migrate-to-module-workers/). | Workers |
| session | An event generated when a user logs in to an Access application. | Cloudflare One |
| session | A session encapsulates all the queries from one logical session for your application. For example, a session may correspond to all queries coming from a particular web browser session. | D1 |
| session identifier | A session identifier is a unique number that a website assigns to identify a specific user for the duration of their visit. | API Shield |
| Set-Cookie | Set-Cookie is an HTTP header used by web servers to send a cookie to a user's browser during an HTTP response, enabling the server to store information on the client side, often used for session management and user preferences. | Waiting Room |
| sFlow | An industry standard packet sampling protocol to monitor network devices. | Magic Network Monitoring |
| SFTP (Secure File Transfer Protocol) | A secure file transfer protocol that uses the Secure Socket Shell (SSH) protocol for encryption and authentication. | Spectrum |
| shadow IT | Shadow IT is the unsanctioned use of software, hardware, or other systems and services within an organization, often without the knowledge of that organization's information technology (IT) department.For more information, refer to the [Cloudflare Learning Center](https://www.cloudflare.com/learning/access-management/what-is-shadow-it/). | Cloudflare One |
| SIEM | A Security Information and Event Management (SIEM) solution collects, analyzes, and correlates data to help manage security incidents, detect anomalies, and meet compliance requirements. | WAF |
| sitekey | The sitekey is used to invoke Turnstile on your site. | Turnstile |
| SMB | Secure Messaging Block (SMB) is a network file sharing protocol used for accessing files and services on a network. | Cloudflare One |
| SMTP | Stands for Simple Mail Transfer Protocol. It is an Internet standard based on TCP/IP to send and receive email. | Area 1 |
| SMTP Server (Simple Mail Transfer Protocol Server) | A server responsible for sending, receiving, and relaying email messages over a network, following the SMTP protocol. | Spectrum |
| Snippets subrequest | Any request that a Snippet makes to either Internet resources using the Fetch API or requests to other Cloudflare services. | Rules |
| source endpoint | The source endpoint is the endpoint managed by API Shield in Endpoint Management by its routing feature. | API Shield |
| speed index | Speed index is a web performance metric that quantifies how quickly a user perceives a webpage to load by measuring the visual progression of content rendering over time, providing a comprehensive assessment of the overall user experience during page loading. | Speed |
| SQL API | API methods part of Storage API that support SQL querying. | Durable Objects |
| SSH | Secure Shell (SSH) protocol allows users to connect to infrastructure remotely and execute commands. | Cloudflare One |
| SSO | Single Sign-On (SSO) is a technology that combines multiple application logins into one, requiring users to enter credentials only once. | Cloudflare One |
| static content | Static content, like images, stylesheets, and JavaScript, remains the same for all users. It can be directly served from the cache without fetching from the origin server because it does not change without manual intervention. | Cache |
| static route | A fixed configuration to route traffic through Anycast tunnels from Cloudflare global network to the customer's locations. | Magic WAN |
| step | A step is self-contained, individually retriable component of a Workflow. Steps may emit (optional) state that allows a Workflow to persist and continue from that step, even if a Workflow fails due to a network or infrastructure issue. A Workflow can have one or more steps up to the [step limit](https://developers.cloudflare.com/workflows/reference/limits/). | Workflows |
| Storage API | The transactional and strongly consistent (serializable) [Storage API](https://developers.cloudflare.com/durable-objects/api/sqlite-storage-api/) for persisting data within each Durable Object. State stored within a unique Durable Object is "private" to that Durable Object, and not accessible from other Durable Objects.Storage API includes key-value (KV) API, SQL API, and point-in-time-recovery (PITR) API.- Durable Object classes with the key-value storage backend can use KV API.
- Durable Object classes with the SQLite storage backend can use KV API, SQL API, and PITR API. | Durable Objects |
| Storage Backend | By default, a Durable Object class can use Storage API that leverages a key-value storage backend. New Durable Object classes can opt-in to using a [SQLite storage backend](https://developers.cloudflare.com/durable-objects/best-practices/access-durable-objects-storage/#sqlite-storage-backend). | Durable Objects |
| stub | An object that refers to a unique Durable Object within a namespace and allows you to call into that Durable Object via RPC methods or the `fetch` API. For example, `let stub = env.MY_DURABLE_OBJECT.get(id)` | Durable Objects |
| Subject Alternative Names (SANs) | The SAN field of an SSL certificate specifies additional hostnames (sites, IP addresses, common names, subdomains, apex domains, etc.) protected by a single SSL Certificate. | SSL/TLS |
| subnet | Also known as subnetwork. It refers to a network that is part of another network. | Magic WAN |
| subrequest | A subrequest is any request that a Worker makes to either Internet resources using the [Fetch API](https://developers.cloudflare.com/workers/runtime-apis/fetch/) or requests to other Cloudflare services like [R2](https://developers.cloudflare.com/r2/), [KV](https://developers.cloudflare.com/kv/), or [D1](https://developers.cloudflare.com/d1/). | Workers |
| SYN (Synchronize) | The initial step in establishing a TCP connection, where a device requests a connection with another by sending a SYN packet. | Spectrum |
| SYN-ACK (Synchronize-Acknowledge) | The second step in the TCP three-way handshake, where the server responds to a SYN request with a SYN-ACK packet. | Spectrum |
| synthetic test | A synthetic test is an artificial simulation of user interactions and system behaviors designed to evaluate and measure the performance, responsiveness, and functionality of a website or application under controlled conditions. | Speed |
| Tail Worker | A [Tail Worker](https://developers.cloudflare.com/workers/observability/logs/tail-workers/) receives information about the execution of other Workers (known as producer Workers), such as HTTP statuses, data passed to `console.log()` or uncaught exceptions. | Workers |
| target | A resource with an IP address or hostname that is reachable by Cloudflare, such as a server or web application. | Cloudflare One |
| target endpoint | The target endpoint is the ultimate destination that a request is sent to by API Shield's routing feature. | API Shield |
| target hostname | A label used to identify a set of targets in an Access for Infrastructure application. | Cloudflare One |
| TCP (Transmission Control Protocol) | A connection-oriented protocol in the transport layer of the Internet Protocol Suite, providing reliable and ordered delivery of data between devices. | Spectrum |
| TCP Fast Open (TFO) | TCP Fast Open (TFO) is a protocol extension that can significantly improve the speed of establishing TCP connections by allowing data to be sent in the initial SYN packet, rather than requiring a separate handshake before data transmission begins. | Fundamentals |
| TCP Keep-Alive | A TCP keep-alive is used to maintain a connection between two endpoints by sending packets to check if the connection is still active. This helps prevent idle connections from being prematurely closed. If a response is not received after a defined period, the connection is terminated. | Fundamentals |
| TCP RST (reset) | A TCP Reset (RST) packet is used by a TCP sender to close a connection. | Fundamentals |
| TCP three-way handshake | TCP uses a three-way handshake to establish a reliable connection (SYN, SYN-ACK, ACK) over an IP based connection. SYN is short for synchronize, and ACK is short for acknowledgement. | Fundamentals |
| team domain | A unique subdomain assigned to your Cloudflare account (for example, `<your-team-name>.cloudflareaccess.com`), where users will find the apps you have secured behind Cloudflare One. | Cloudflare One |
| team name | The customizable portion of your team domain (`<your-team-name>.cloudflareaccess.com`). You can view your team name in Cloudflare One under **Settings**. | Cloudflare One |
| Terraform | An infrastructure as code software tool that allows you to deploy services from different providers using a standardized configuration syntax. | Cloudflare One |
| threat score | The threat score was a score from `0` (zero risk) to `100` (high risk) classifying the IP reputation of a visitor. Currently, the threat score is always `0` (zero). | WAF |
| time to first byte (TTFB) | Time to first byte (TTFB) is the duration measured from the initiation of a web page request to the moment the first byte of data is received by the user's browser from the web server, indicating the server's initial response time. | Speed |
| time to interactive (TTI) | Time to interactive (TTI) is a web performance metric that measures the time it takes for a web page to become fully interactive and responsive to user input, indicating when users can effectively engage with and use the page. | Speed |
| time-to-live (TTL) | The duration for which a cached copy of a resource is considered valid before it needs to be refreshed or revalidated. | Cache |
| timestamp | A data field indicating the date and time when an event occurred, often used for sequencing and analysis. | Logs |
| TLS (Transport Layer Security) | TLS is a cryptographic protocol that ensures data security over a computer network, such as the Internet. It encrypts the data that is transmitted between a user's computer and a web server. | SSL/TLS |
| total bandwidth (total egress bandwidth, edge bandwidth) | Total bandwidth is the amount of data transferred from Cloudflare to end users within a certain period of time. Total bandwidth equals the sum of all `EdgeResponseBytes` for a certain period of time. | Cache |
| total blocking time (TBT) | Total blocking time (TBT) is a web performance metric that measures the total amount of time between First Contentful Paint (FCP) and Time to Interactive (TTI) where the main thread was blocked for long enough to prevent input responsiveness. | Speed |
| traffic | Traffic is the data sent and received by visitors to a website. Cloudflare serves and protects this data as it passes through the Cloudflare network. | Fundamentals |
| traffic management | The process of controlling and optimizing the flow of network data to ensure efficient and reliable communication. | Waiting Room |
| traffic steering | Cloudflare evaluates your route's health and steers traffic according to priorities defined by you and / or tunnel health. | Magic WAN |
| tunnel | A secure pathway for network traffic to flow between a device and Cloudflare's global network. | Cloudflare One |
| tunnel health-check | A probe sent by Cloudflare to check for tunnel health. If a tunnel is not considered healthy, Cloudflare reroutes traffic to one that is considered healthy. | Magic WAN |
| tutorial | A tutorial is a practical lesson that takes you from a clear starting to ending point.The goal is to connect products to real-world scenarios to meet a user’s goal. | Fundamentals |
| two-factor authentication (2FA) | Two-factor authentication (2FA) is a security process in which a user provides two different authentication factors to verify their identity. In addition to something you know, typically your password, 2FA adds an extra layer of security to user logins by requiring users to also present something they have, such as Yubikey or a one-time login code, or something you are, such as a fingerprint.It adds an extra layer of security to user logins by requiring users to present two or more separate pieces of evidence (factors) that establish their identity. | Fundamentals |
| UDP (User Datagram Protocol) | UDP (User Datagram Protocol) is a connectionless transport layer protocol that provides fast and lightweight data transmission between devices on a network, prioritizing speed over reliability. | Spectrum |
| uncached bandwidth (uncached egress bandwidth) | Uncached bandwidth is the amount of bandwidth that is not cached and therefore is served from the origin. Uncached bandwidth is the sum of all `EdgeResponseBytes` where `CacheCacheStatus` does not equal `hit`, `stale`, `updating`, `ignored`, or `revalidated`. | Cache |
| uncached requests | Uncached requests are requests that are not cached and therefore are served from the origin server. Uncached requests are the sum of all requests where `CacheCacheStatus` does not equal to `hit`, `stale`, `updating`, or `ignored`. | Cache |
| Unicast Reverse Path Forwarding (uRPF) | A security feature that can prevent spoofing attacks. | BYOIP |
| Universal SSL certificate | By default, Cloudflare issues — and [renews](https://developers.cloudflare.com/ssl/reference/certificate-validity-periods/#universal-ssl) — free, unshared, publicly trusted SSL certificates to all domains [added to](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) and [activated on](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/) Cloudflare. | SSL/TLS |
| URL normalization | The process of modifying the URLs of incoming requests so that they conform to a consistent formatting standard. | Rules |
| URL rewrite | An operation performed by a server that converts a source URL into a target URL. | Rules |
| User risk score | Ranks the likelihood of a user to introduce risk to your organization's systems and data based on the detection of security risk behaviors. Risk scores add user and entity behavior analytics (UEBA) to the Cloudflare One platform. | Cloudflare One |
| User risk score level | Cloudflare One assigns a risk score of Low, Medium or High based on detections of users' activities, posture, and settings. A user's risk score is equal to the highest-level risk behavior they trigger. | Cloudflare One |
| V8 | Chrome V8 is a [JavaScript engine](https://www.cloudflare.com/learning/serverless/glossary/what-is-chrome-v8/), which means that it [executes JavaScript code](https://developers.cloudflare.com/workers/reference/how-workers-works/). | Workers |
| validation level | The level to which a certificate authority validates domain ownership before issuing an SSL/TLS certificate.The different certificate validation levels are DV (Domain Validated), OV (Organization Validated), or EV (Extended Validation). | SSL/TLS |
| verified bot | Bots that are transparent about who they are and what they do. | Bots |
| version | A [version](https://developers.cloudflare.com/workers/configuration/versions-and-deployments/#versions) is defined by the state of code as well as the state of configuration in a Worker's Wrangler file. | Workers |
| Virtual network | A software abstraction that allows you to logically segregate resources on a private network. Virtual networks are especially useful for exposing resources which have overlapping IP routes. | Cloudflare One |
| Virtual Private Cloud | A logically isolated section of cloud infrastructure that provides secure, private networking within a public cloud environment. | Workers VPC |
| Virtual Private Cloud (VPC) | A secure, isolated private network hosted on public cloud infrastructure. Examples of public cloud providers include Google Cloud, AWS, and Microsoft Azure. | Cloudflare One |
| Virtual Private Network (VPN) | A tool that allows users to send and receive data across shared or public networks as if their devices were directly connected to the private network. For example, employees working from home can use a VPN to access files on the corporate network. | Cloudflare One |
| virtual waiting room | A virtual waiting room is an online system or feature that manages and controls access to a website or service during periods of high traffic, preventing server overload by placing users in a queue until they can be accommodated, ensuring a more equitable and efficient user experience. | Waiting Room |
| wall-clock time | [Wall-clock time](https://developers.cloudflare.com/workers/platform/limits/#duration) is the total amount of time from the start to end of an invocation of a Worker. | Workers |
| WAN | Stands for Wide Area Network. It refers to a computer network that connects groups of computers over large distances. WANs are often used by businesses to connect their office networks. The objective is to make each of the local area networks (LANs) be remotely connected and accessible. | Magic WAN |
| WARP client | An application that connects corporate devices to Cloudflare for private network access, advanced web filtering, and other security functions. | Cloudflare One |
| WARP Connector | An extension of the WARP client used to establish site-to-site, bidirectional, and mesh networking connectivity. WARP Connector software installs on a Linux server within a private network, which then becomes a gateway for other local networks that need to on-ramp traffic to Cloudflare. | Cloudflare One |
| website | A website is a collection of web pages and related content that is identified by a common domain name and published on at least one web server. | Fundamentals |
| Worker Bindings | [Worker Bindings](https://developers.cloudflare.com/workers-ai/configuration/bindings/) are configurations that connect Workers scripts to external resources, such as AI models, enabling seamless integration and functionality. | Workers AI |
| workerd | [`workerd`](https://github.com/cloudflare/workerd?cf_target_id=D15F29F105B3A910EF4B2ECB12D02E2A) is a JavaScript / Wasm server runtime based on the same code that powers Cloudflare Workers. | Workers |
| Workers AI | [Workers AI](https://developers.cloudflare.com/workers-ai/) is a Cloudflare service that enables running machine learning models on Cloudflare's global network, utilizing serverless GPUs. It allows developers to integrate AI capabilities into their applications using Workers, Pages, or via the REST API. | Workers AI |
| Workers KV | [Workers KV](https://developers.cloudflare.com/kv/)is a data storage that allows you to store and retrieve data globally. | Workers AI |
| Workflow | The named Workflow definition, associated with a single Workers script. | Workflows |
| Wrangler | [Wrangler](https://developers.cloudflare.com/learning-paths/workers/get-started/c3-and-wrangler/) is the Cloudflare Developer Platform command-line interface (CLI) that allows you to manage projects, such as Workers, created from the Cloudflare Developer Platform product offering. | Workers |
| Wrangler CLI | [Wrangler CLI](https://developers.cloudflare.com/workers-ai/get-started/workers-wrangler/) is a command-line tool for building and deploying Cloudflare Workers, facilitating the integration of AI models into applications. | Workers AI |
| wrangler.toml / wrangler.json / wrangler.jsonc | The [configuration](https://developers.cloudflare.com/workers/wrangler/configuration/) used to customize the development and deployment setup for a Worker or a Pages Function. | Workers |
| Zero Trust Security | Zero Trust Security is an IT security model that requires strict identity verification for every person and device accessing resources on a network. | Cloudflare One |
| zone | A zone is a portion of DNS namespace that is managed by a specific organization or administrator. | Fundamentals |
| zone apex | Zone apex refers to the domain or subdomain on which the control of DNS records starts. | DNS |
