---
title: Cloudflare product compatibility · Cloudflare Data Localization Suite docs
description: The table below provides a summary of the Data Localization Suite
  product's behavior with Cloudflare products. Refer to the table legend for
  guidance on interpreting the table.
lastUpdated: 2025-11-14T09:29:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/compatibility/
  md: https://developers.cloudflare.com/data-localization/compatibility/index.md
---

The table below provides a summary of the Data Localization Suite product's behavior with Cloudflare products. Refer to the table legend for guidance on interpreting the table.

✅ Product works with no caveats\
🚧 Product can be used with some caveats\
✘ Product cannot be used\
⚫️ Not applicable

## Application Performance

| Product | Geo Key Manager | Regional Services | Customer Metadata Boundary |
| - | - | - | - |
| Caching/CDN | ✅ | ✅ | ✅ |
| Cache Reserve | ⚫️ | 🚧 | ✅ [1](#user-content-fn-29) |
| DNS | ⚫️ | 🚧 [2](#user-content-fn-33) | 🚧 [3](#user-content-fn-32) |
| HTTP/3 (with QUIC) | ⚫️ | ✘ | ⚫️ |
| Image Resizing | ✅ | ✅ [4](#user-content-fn-6) | 🚧 [5](#user-content-fn-1) |
| Load Balancing | ✅ | ✅ | 🚧 [5](#user-content-fn-1) |
| Network Error Logging (NEL) | ⚫️ | ⚫️ | ✘ |
| Onion Routing | ✘ | ✘ | ✘ |
| Orange-to-Orange (O2O) | ✘ | ✘ | ✘ |
| Stream Delivery | ✅ | ✅ | ✅ |
| Tiered Caching | ✅ | 🚧 [6](#user-content-fn-2) | 🚧 [7](#user-content-fn-30) |
| Trace | ✘ | ✘ | ✘ |
| Waiting Room | ⚫️ | ✅ | ✅ |
| Web Analytics / Real User Monitoring (RUM) | ⚫️ | ⚫️ | ✘ [8](#user-content-fn-43) |
| Zaraz | ✅ | ✅ | ✅ |

***

## Application Security

| Product | Geo Key Manager | Regional Services | Customer Metadata Boundary |
| - | - | - | - |
| Advanced Certificate Manager | ⚫️ | ⚫️ | ⚫️ |
| Advanced DDoS Protection | ✅ | ✅ | 🚧 [9](#user-content-fn-3) |
| API Shield | ✅ | ✅ | 🚧 [10](#user-content-fn-4) |
| Bot Management | ✅ | ✅ | ✅ |
| DNS Firewall | ⚫️ | ⚫️ | 🚧 [11](#user-content-fn-22) |
| Page Shield | ✅ | ✅ | ✅ |
| Rate Limiting | ✅ | ✅ | ✅ [12](#user-content-fn-37) |
| SSL | ✅ | ✅ | ✅ |
| Cloudflare for SaaS | ✘ | ✅ | ✅ |
| Turnstile | ⚫️ | ✘ | ✅ [13](#user-content-fn-38) |
| WAF/L7 Firewall | ✅ | ✅ | ✅ |
| DMARC Management | ⚫️ | ⚫️ | ✅ |

***

## Developer Platform

| Product | Geo Key Manager | Regional Services | Customer Metadata Boundary |
| - | - | - | - |
| Cloudflare Images | ⚫️ | ✅ [14](#user-content-fn-36) | 🚧 [15](#user-content-fn-35) |
| AI Gateway | ✘ | ✘ | 🚧 [16](#user-content-fn-39) |
| Cloudflare Pages | ✅ [17](#user-content-fn-11) | ✅ [17](#user-content-fn-11) | 🚧 [5](#user-content-fn-1) |
| Cloudflare D1 | ⚫️ | ⚫️ | 🚧 [18](#user-content-fn-40) |
| Durable Objects | ⚫️ | ✅ [19](#user-content-fn-7) | 🚧 [5](#user-content-fn-1) |
| Email Routing | ⚫️ | ⚫️ | ✅ |
| R2 | ✅ [20](#user-content-fn-27) | ✅ [21](#user-content-fn-8) | ✅ [22](#user-content-fn-28) |
| Smart Placement | ⚫️ | ✘ | ✘ |
| Stream | ⚫️ | ✘ | 🚧 [5](#user-content-fn-1) |
| Workers (deployed on a Zone) | ✅ | ✅ | 🚧 [23](#user-content-fn-41) |
| Workers AI | ⚫️ | ✘ | ✅ |
| Workers KV | ⚫️ | ✘ | ✅ [24](#user-content-fn-34) |
| Workers.dev | ✘ | ✘ | ✘ |
| Workers Analytics Engine (WAE) | ⚫️ | ⚫️ | 🚧 [5](#user-content-fn-1) |

***

## Network Services

| Product | Geo Key Manager | Regional Services | Customer Metadata Boundary |
| - | - | - | - |
| Argo Smart Routing | ✅ | ✘ [25](#user-content-fn-9) | ✘ [26](#user-content-fn-10) |
| Static IP/BYOIP | ⚫️ | ✅ [27](#user-content-fn-26) | ⚫️ |
| Magic Firewall | ⚫️ | ⚫️ | ✅ |
| Magic Network Monitoring | ⚫️ | ⚫️ | 🚧 [5](#user-content-fn-1) |
| Magic Transit | ⚫️ | ⚫️ | ✅ |
| Magic WAN | ⚫️ | ⚫️ | ✅ |
| Spectrum | ✅ | ✅ [28](#user-content-fn-42) | ✅ |

***

## Platform

| Product | Geo Key Manager | Regional Services | Customer Metadata Boundary |
| - | - | - | - |
| Logpull | ⚫️ | ⚫️ | 🚧 [29](#user-content-fn-12) |
| Logpush | ⚫️ | ✅ | 🚧 [30](#user-content-fn-13) |
| Log Explorer | ⚫️ | ⚫️ | ✘ [31](#user-content-fn-23) |

***

## Zero Trust

| Product | Geo Key Manager | Regional Services | Customer Metadata Boundary |
| - | - | - | - |
| Access | 🚧 [32](#user-content-fn-14) | 🚧 [33](#user-content-fn-15) | ✅ [34](#user-content-fn-16) |
| Browser Isolation | ⚫️ | 🚧 [35](#user-content-fn-17) | ✅ |
| CASB | ⚫️ | ⚫️ | ✘ |
| Cloudflare Tunnel | ⚫️ | 🚧 [36](#user-content-fn-18) | ⚫️ |
| DLP | ⚫️ [37](#user-content-fn-19) | ⚫️ [37](#user-content-fn-19) | 🚧 [38](#user-content-fn-31) |
| Gateway | 🚧 [39](#user-content-fn-20) | 🚧 [40](#user-content-fn-21) | 🚧 [11](#user-content-fn-22) |
| WARP | ⚫️ | ⚫️ | 🚧 [5](#user-content-fn-1) |

## Footnotes

1. You cannot yet specify region location for object storage itself. [↩](#user-content-fnref-29)

2. [Outgoing zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-primary/) will carry Earth region proxy IPs, thus making regional service dysfunctional when non-Cloudflare nameservers respond to the DNS queries. [↩](#user-content-fnref-33)

3. Dashboard Analytics are empty when using CMB outside the US region. Use Logpush instead. [↩](#user-content-fnref-32)

4. Only when using a Custom Domain set to a region, either through Workers or [Transform Rules](https://developers.cloudflare.com/images/transform-images/serve-images-custom-paths/) within the same zone. [↩](#user-content-fnref-6)

5. Logs / Analytics not available outside US region when using Customer Metadata Boundary. [↩](#user-content-fnref-1) [↩2](#user-content-fnref-1-2) [↩3](#user-content-fnref-1-3) [↩4](#user-content-fnref-1-4) [↩5](#user-content-fnref-1-5) [↩6](#user-content-fnref-1-6) [↩7](#user-content-fnref-1-7) [↩8](#user-content-fnref-1-8)

6. Regular and Custom Tiered Cache works; Smart Tiered Caching not available with Regional Services. [↩](#user-content-fnref-2)

7. Regular/Generic and Custom Tiered Cache works; Smart Tiered Caching does not work with Customer Metadata Boundary (CMB).\
   With CMB set to EU, the Zone Dashboard **Caching** > **Tiered Cache** > **Smart Tiered Caching** option will not populate the Dashboard Analytics. [↩](#user-content-fnref-30)

8. Web Analytics collects the [minimum amount of information](https://developers.cloudflare.com/web-analytics/data-metrics/data-origin-and-collection/). Alternatively, you can [exclude EU Visitors from RUM](https://developers.cloudflare.com/speed/observatory/rum-beacon/#rum-excluding-eeaeu). [↩](#user-content-fnref-43)

9. [Adaptive DDoS Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/adaptive-protection/) is only supported for CMB = US. All other features are available to all CMB regions. [↩](#user-content-fnref-3)

10. API Discovery, Volumetric Abuse Detection and [Sequence Analytics and Mitigation](https://developers.cloudflare.com/api-shield/security/sequence-analytics/) will not work with CMB = EU. All other features are available to all CMB regions. [↩](#user-content-fnref-4)

11. Dashboard Analytics and Logs are empty when using CMB outside the US region. Use Logpush instead. [↩](#user-content-fnref-22) [↩2](#user-content-fnref-22-2)

12. Legacy Zone Analytics & Logs section not available outside US region when using CMB. Use [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) instead. [↩](#user-content-fnref-37)

13. [Turnstile Analytics](https://developers.cloudflare.com/turnstile/turnstile-analytics/) are available. However, there are no regionalization guarantees for the Siteverify API yet. [↩](#user-content-fnref-38)

14. Only when using a [Custom Domain](https://developers.cloudflare.com/images/manage-images/serve-images/serve-from-custom-domains/) set to a region. [↩](#user-content-fnref-36)

15. Logs / Analytics not supported for CMB = EU. Jurisdictional Restrictions ([storage](https://developers.cloudflare.com/images/upload-images/)) options are not supported today. All other features are available to all CMB regions. Note that beta or future features may not be in scope and could be subject to change. [↩](#user-content-fnref-35)

16. Jurisdictional Restrictions (storage) options for [Logs](https://developers.cloudflare.com/ai-gateway/observability/logging/) are not supported today. All other features are available to all CMB regions. [↩](#user-content-fnref-39)

17. Only when using [Custom Domain](https://developers.cloudflare.com/pages/configuration/custom-domains/) set to a region. [↩](#user-content-fnref-11) [↩2](#user-content-fnref-11-2)

18. Jurisdictional Restrictions ([data location](https://developers.cloudflare.com/d1/configuration/data-location/) / storage) options are not supported today. All other features are available to all CMB regions. Note that beta or future features may not be in scope and could be subject to change. [↩](#user-content-fnref-40)

19. [Jurisdiction restrictions for Durable Objects](https://developers.cloudflare.com/durable-objects/reference/data-location/#restrict-durable-objects-to-a-jurisdiction). [↩](#user-content-fnref-7)

20. Only when using a Custom Domain and a [Custom Certificate](https://developers.cloudflare.com/r2/reference/data-security/#encryption-in-transit) or [Keyless SSL](https://developers.cloudflare.com/ssl/keyless-ssl/). [↩](#user-content-fnref-27)

21. Only when using a [Custom Domain](https://developers.cloudflare.com/r2/buckets/public-buckets/#connect-a-bucket-to-a-custom-domain) set to a region and using [jurisdictions with the S3 API](https://developers.cloudflare.com/r2/reference/data-location/#using-jurisdictions-with-the-s3-api). [↩](#user-content-fnref-8)

22. R2 Dashboard [Metrics and Analytics](https://developers.cloudflare.com/r2/platform/metrics-analytics/) are populated. [Jurisdictional Restrictions](https://developers.cloudflare.com/r2/reference/data-location/#jurisdictional-restrictions) guarantee objects in a bucket are stored within a specific jurisdiction. [↩](#user-content-fnref-28)

23. Logs / Analytics not available outside US region when using Customer Metadata Boundary. Use Logpush instead. [↩](#user-content-fnref-41)

24. Jurisdictional Restrictions (storage) for Workers KV pairs is not supported today. [↩](#user-content-fnref-34)

25. Argo cannot be used with Regional Services. [↩](#user-content-fnref-9)

26. Argo cannot be used with Customer Metadata Boundary. [↩](#user-content-fnref-10)

27. Static IP/BYOIP can be used with the legacy Spectrum setup. [↩](#user-content-fnref-26)

28. Only applies to HTTP/S Spectrum applications. [↩](#user-content-fnref-42)

29. Logpull available when using CMB = US only. Logpull is a legacy feature, consider using [Logpush](https://developers.cloudflare.com/data-localization/metadata-boundary/logpush-datasets/) or [Log Explorer](https://developers.cloudflare.com/log-explorer/) instead. [↩](#user-content-fnref-12)

30. Logpush available with Customer Metadata Boundary for [these datasets](https://developers.cloudflare.com/data-localization/metadata-boundary/logpush-datasets/). Contact your account team if you need another dataset. [↩](#user-content-fnref-13)

31. Currently, customers do not have the ability to choose the location of the Cloudflare-managed R2 bucket for Log Explorer. [↩](#user-content-fnref-23)

32. Access App SSL keys can use Geo Key Manager. [Access JWT](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/validating-json/) is not yet localized. [↩](#user-content-fnref-14)

33. Can be localized to US FedRAMP Moderate Domestic region only. [↩](#user-content-fnref-15)

34. Customer Metadata Boundary can be used to limit data transfer outside region, but Access User Logs will not be available outside US region. EU customers must use Logpush to retain logs. [↩](#user-content-fnref-16)

35. Currently may only be used with US FedRAMP region. [↩](#user-content-fnref-17)

36. When Cloudflare Tunnel connects to Cloudflare, the connectivity options available are the Global Region (default) and [US FedRAMP Moderate Domestic region](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/run-parameters/#region). For incoming requests to the Cloudflare Edge, Regional Services only applies when using [published applications](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/). In this case, the region associated with the DNS record will apply. [↩](#user-content-fnref-18)

37. Uses Gateway HTTP and CASB. [↩](#user-content-fnref-19) [↩2](#user-content-fnref-19-2)

38. DLP is part of Gateway HTTP, however, [DLP detection entries](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/detection-entries/) are not available outside US region when using Customer Metadata Boundary. [↩](#user-content-fnref-31)

39. You can [bring your own certificate](https://blog.cloudflare.com/bring-your-certificates-cloudflare-gateway/) to Gateway but these cannot yet be restricted to a specific region. [↩](#user-content-fnref-20)

40. Gateway HTTP supports Regional Services. Gateway DNS does not yet support regionalization.\
    ICMP proxy and WARP-to-WARP proxy are not available to Regional Services users. [File Sandboxing](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/file-sandboxing/) (add-on) is incompatible with DLS. [↩](#user-content-fnref-21)
